/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class VWTitledBorder
extends AbstractBorder {
    public static final Color BGCOLOR_LTGRAY = new Color(220, 221, 222);
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_SPACING = 2;
    protected static final int TEXT_INSET_H = 5;
    private String m_title;
    private Border m_border;

    public VWTitledBorder(String title) {
        this.m_title = title;
    }

    public Dimension getMinimumSize(Component c) {
        Insets insets = this.getBorderInsets(c);
        Dimension minSize = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
        Font font = this.getFont(c);
        FontMetrics fm = c.getFontMetrics(font);
        minSize.width += fm.stringWidth(this.m_title);
        return minSize;
    }

    public void showBorder(boolean bShowBorder) {
        this.m_border = bShowBorder ? UIManager.getBorder("TitledBorder.border") : null;
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        int descent = 0;
        int ascent = 16;
        if (this.m_border != null) {
            if (this.m_border instanceof AbstractBorder) {
                ((AbstractBorder)this.m_border).getBorderInsets(c, insets);
            } else {
                Insets i = this.m_border.getBorderInsets(c);
                insets.top = i.top;
                insets.right = i.right;
                insets.bottom = i.bottom;
                insets.left = i.left;
            }
        } else {
            insets.bottom = 0;
            insets.right = 0;
            insets.top = 0;
            insets.left = 0;
        }
        insets.left += 4;
        insets.right += 4;
        insets.top += 4;
        insets.bottom += 4;
        if (c == null || this.m_title == null || this.m_title.equals("")) {
            return insets;
        }
        Font font = this.getFont(c);
        FontMetrics fm = c.getFontMetrics(font);
        if (fm != null) {
            descent = fm.getDescent();
            ascent = fm.getAscent();
        }
        insets.top += ascent + descent;
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.m_title == null || this.m_title.equals("")) {
            if (this.m_border != null) {
                this.m_border.paintBorder(c, g, x, y, width, height);
            }
            return;
        }
        Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Font font = g.getFont();
        Color color = g.getColor();
        g.setFont(this.getFont(c));
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int descent = fm.getDescent();
        int ascent = fm.getAscent();
        Point textLoc = new Point();
        Insets insets = this.m_border != null ? this.m_border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        int diff = Math.max(0, ascent / 2 + 2 - 2);
        grooveRect.y += diff;
        grooveRect.height -= diff;
        textLoc.y = grooveRect.y - descent + (insets.top + ascent + descent) / 2 + 1;
        if (c.getComponentOrientation().isLeftToRight()) {
            textLoc.x = grooveRect.x + 5 + insets.left;
        } else {
            Rectangle2D textRect = fm.getStringBounds(this.m_title, g);
            textLoc.x = grooveRect.width - ((int)textRect.getWidth() + 5 + insets.left);
        }
        if (this.m_border != null) {
            this.m_border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
        }
        grooveRect = new Rectangle(x + 4, y, width - 8, fontHeight + 2);
        g.setColor(BGCOLOR_LTGRAY);
        g.fillRect(grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
        g.setColor(color);
        g.drawString(this.m_title, textLoc.x, textLoc.y);
        g.setFont(font);
    }

    private Font getFont(Component c) {
        Font font;
        if (c != null && (font = c.getFont()) != null) {
            return new Font(font.getName(), 1, font.getSize());
        }
        return new Font("Dialog", 1, 12);
    }
}

